/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IMiniMapData;
import noppes.npcs.util.Util;

public class MiniMapData
implements IMiniMapData {
    private int questId = -1;
    private int taskId = -1;
    private boolean update = false;
    public int id = 0;
    public int color;
    public int[] dimIDs = new int[]{0};
    public String name = "default map point";
    public String type = "Normal";
    public String icon = "icon.png";
    public IPos pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(BlockPos.field_177992_a);
    public boolean isEnable = true;
    public Map<String, String> gsonData = new TreeMap<String, String>();

    public MiniMapData() {
        this.color = (int)(-1.6777216E7 + Math.random() * 1.6777215E7);
    }

    public void setQuestId(int id) {
        this.questId = id;
    }

    public void setTaskId(int id) {
        this.taskId = id;
    }

    public boolean equals(Object obj) {
        boolean equalDimIDs;
        if (!(obj instanceof MiniMapData)) {
            return false;
        }
        MiniMapData mmd = (MiniMapData)obj;
        boolean bl = equalDimIDs = this.dimIDs.length == mmd.dimIDs.length;
        if (equalDimIDs) {
            int eq = 0;
            block0: for (int idp : this.dimIDs) {
                for (int idd : mmd.dimIDs) {
                    if (idp != idd) continue;
                    ++eq;
                    continue block0;
                }
            }
            equalDimIDs = this.dimIDs.length == eq;
        }
        return equalDimIDs && this.id == mmd.id && this.color == mmd.color && this.name.equals(mmd.name) && this.type.equals(mmd.type) && this.icon.equals(mmd.icon) && this.pos.getMCBlockPos().equals((Object)mmd.pos.getMCBlockPos()) && this.isEnable == mmd.isEnable;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int[] getDimensions() {
        return this.dimIDs;
    }

    @Override
    public String getIcon() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPos getPos() {
        return this.pos;
    }

    @Override
    public String[] getSpecificKeys() {
        return this.gsonData.keySet().toArray(new String[0]);
    }

    @Override
    public String getSpecificValue(String key) {
        return this.gsonData.get(key);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    public boolean isQuestTask(int questId, int taskId) {
        return this.questId == questId && (taskId < 0 || this.taskId == taskId);
    }

    public boolean isUpdate() {
        if (this.update) {
            this.update = false;
            return true;
        }
        return false;
    }

    public void load(NBTTagCompound compound) {
        this.isEnable = compound.func_74767_n("IsEnable");
        this.questId = compound.func_74762_e("QuestID");
        this.taskId = compound.func_74762_e("TaskID");
        this.dimIDs = compound.func_74759_k("DimensionID");
        this.color = compound.func_74762_e("Color");
        this.id = compound.func_74762_e("ID");
        this.type = compound.func_74779_i("Type");
        this.name = Util.instance.deleteColor(compound.func_74779_i("Name"));
        this.icon = compound.func_74779_i("Icon");
        this.pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(BlockPos.func_177969_a((long)compound.func_74763_f("Pos")));
        this.gsonData.clear();
        for (int i = 0; i < compound.func_150295_c("GsonData", 10).func_74745_c(); ++i) {
            NBTTagCompound gsonNBT = compound.func_150295_c("GsonData", 10).func_150305_b(i);
            this.gsonData.put(gsonNBT.func_74779_i("K"), gsonNBT.func_74779_i("V"));
        }
        this.update = false;
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("IsEnable", this.isEnable);
        compound.func_74768_a("QuestID", this.questId);
        compound.func_74768_a("TaskID", this.taskId);
        compound.func_74783_a("DimensionID", this.dimIDs);
        compound.func_74768_a("Color", this.color);
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("Type", this.type);
        compound.func_74778_a("Name", Util.instance.deleteColor(this.name));
        compound.func_74778_a("Icon", this.icon);
        compound.func_74772_a("Pos", this.pos.getMCBlockPos().func_177986_g());
        NBTTagList gsonList = new NBTTagList();
        for (String key : this.gsonData.keySet()) {
            NBTTagCompound gsonNBT = new NBTTagCompound();
            gsonNBT.func_74778_a("K", key);
            gsonNBT.func_74778_a("V", this.gsonData.get(key));
            gsonList.func_74742_a((NBTBase)gsonNBT);
        }
        compound.func_74782_a("GsonData", (NBTBase)gsonList);
        return compound;
    }

    @Override
    public void setColor(int newColor) {
        if (this.color == newColor) {
            return;
        }
        this.color = newColor;
        this.update = true;
    }

    @Override
    public void setDimensions(int[] dims) {
        if (dims == null || dims.length == 0) {
            return;
        }
        this.dimIDs = dims;
    }

    @Override
    public void setIcon(String newIcon) {
        if (newIcon == null) {
            newIcon = "";
        }
        if (this.icon.equals(newIcon)) {
            return;
        }
        this.icon = newIcon;
        this.update = true;
    }

    @Override
    public void setName(String newName) {
        if ((newName = Util.instance.deleteColor(newName)) == null) {
            newName = "";
        }
        if (this.name.equals(newName)) {
            return;
        }
        this.name = newName;
        this.update = true;
    }

    @Override
    public void setPos(int x, int y, int z) {
        BlockPos newPos = new BlockPos(x, y, z);
        if (this.pos.getMCBlockPos().equals((Object)newPos)) {
            return;
        }
        this.pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(newPos);
        this.update = true;
    }

    @Override
    public void setPos(IPos newPos) {
        if (newPos == null) {
            newPos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(BlockPos.field_177992_a);
        }
        if (this.pos.getMCBlockPos().equals((Object)newPos.getMCBlockPos())) {
            return;
        }
        this.pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(newPos.getMCBlockPos());
        this.update = true;
    }

    public void setQuest(MiniMapData parent) {
        this.questId = parent.questId;
        this.taskId = parent.taskId;
    }

    @Override
    public void setType(String newType) {
        if (newType == null) {
            newType = "";
        }
        if (this.type.equals(newType)) {
            return;
        }
        this.type = newType;
        this.update = true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_7;
        StringBuilder gs = new StringBuilder("empty");
        if (!this.gsonData.isEmpty()) {
            gs = new StringBuilder();
            for (String string : this.gsonData.keySet()) {
                if (gs.length() > 0) {
                    gs.append(", ");
                }
                gs.append("(").append(string).append("=").append(this.gsonData.get(string)).append(")");
            }
            gs = new StringBuilder("[" + gs + "]");
        }
        StringBuilder ds = new StringBuilder();
        for (int id : this.dimIDs) {
            if (ds.length() > 0) {
                ds.append(", ");
            }
            ds.append(id);
        }
        ds = new StringBuilder("[" + ds + "]");
        String string = "";
        if (this.questId != -1) {
            String string2 = ", QuestID: " + this.questId + ", TaskID: " + this.taskId;
        }
        return "Point Data: {ID: " + this.id + ", Name: " + this.name + ", Type: " + this.type + ", Icon: " + this.icon + ", Color: " + this.color + ", Pos: " + this.pos.getMCBlockPos() + ", DimensionIDs: " + ds + ", IsEnable: " + this.isEnable + ", GsonData: " + gs + (String)var3_7 + "}";
    }
}

